<%-----Licence check-----%>
<%@ page import="java.io.*, java.nio.file.*, com.google.gson.*" %>
<%@ include file="utils.jspf" %>

<%!
    class LicenseCheckResult {
        String status;
        Map<String, String> errors = new HashMap<>();
        Map<String, String> warnings = new HashMap<>();
        Map<String, Object> extraInfo = new HashMap<>();
        List<String> resolutions;

        LicenseCheckResult(boolean fileExists, boolean stringMatches, String readError) {
            this.resolutions = new ArrayList<>();
            if (!fileExists) {
                this.status = "fail";
                this.errors.put("License File", "The license.txt file is missing.");
                this.resolutions.add(resolutionMessages.getOrDefault("E06", "Please Add license"));

            } else if (readError != null) {
                this.status = "fail";
                this.errors.put("Read Error", "Failed to read license.txt: " + readError);
            } else if (stringMatches) {
                this.status = "fail";
                this.errors.put("Invalid Key", "Please add license");
                this.resolutions.add(resolutionMessages.getOrDefault("E07", "Contact Vitara Support"));
            } else {
                this.status = "pass";
            }
        }
    }
%>

<%
    String filePath = getRealPath(application, "VitaraCharts/license.txt");
    boolean fileExists = false;
    boolean stringMatches = false;
    String readError = null;
    String forbiddenString = "fc44ee62b62b3f5108ab5c35bc2eb63c;cid;instance;VDk3ODMwNzIwMDAwMA==;1_-1_-1_LTE7;c040f394e63cff708e5b40f151ca33f7";

    File file = new File(filePath);
    if (file.exists()) {
        fileExists = true;
        try {
            String content = new String(Files.readAllBytes(file.toPath()));
            stringMatches = content.contains(forbiddenString);
        } catch (IOException e) {
            readError = e.getMessage();
        }
    }

    LicenseCheckResult result = new LicenseCheckResult(fileExists, stringMatches, readError);

    Gson gson = new Gson();
    String json = gson.toJson(result);
    response.setContentType("application/json");
    response.setCharacterEncoding("UTF-8");
    out.print(json);
    out.flush();
%>
