import * as utils from "../utility/helper-functions.js";

const settingsData = {};
const ibcsSettingsData = {};
const fontFaceDefinitions = [];
const translationsData = {};
const stylesData = {};
const ibcsStylesData = {};
let unsavedChanges = false;
const blockSave = {
    blockedPages: [],
    reason: ""
};

function getSettingsData() {
    return settingsData;
}

function getIBCSSettingsData() {
    return ibcsSettingsData;
}

function updateSettingsData(key, value) {
    if (value === null || value === undefined || value === "") {
        delete settingsData[key];
    } else {
        settingsData[key] = value;
    }
}

function updateIBCSSettingsData(key, value) {
    if (value === null || value === undefined || value === "") {
        delete ibcsSettingsData[key];
    } else {
        ibcsSettingsData[key] = value;
    }
}

function getStylesData() {
    return stylesData;
}

function getIBCSStylesData() {
    return ibcsStylesData;
}

function updateStylesData(key, value) {
    stylesData[key] = value;
}

function updateIBCSStylesData(key, value) {
    ibcsStylesData[key] = value;
}

function getFontFaceDefinitions() {
    return fontFaceDefinitions;
}

function addFontFaceDefinition(definition) {
    fontFaceDefinitions.push(definition);
}

function removeFontFaceDefinition(fontName) {
    const index = fontFaceDefinitions.findIndex(def => def.includes(fontName));
    if (index !== -1) {
        fontFaceDefinitions.splice(index, 1);
    }
}

function getTranslationsData() {
    return translationsData;
}

function updateTranslationsData(key, value) {
    if (value) {
        translationsData[key] = value;
    }
}

function refreshTranslationsData(newTranslations) {
    utils.clearObject(translationsData);
    Object.assign(translationsData, newTranslations);
}

function hasUnsavedChanges() {
    return unsavedChanges;
}

function setUnsavedChanges(value) {
    unsavedChanges = value;
}

function getBlockedPages() {
    return blockSave;
}

function addBlockedPage(page, reason) {
    if (!blockSave.blockedPages.includes(page)) {
        blockSave.blockedPages.push(page);
    }
    blockSave.reason = reason || "";
}

function removeBlockedPage(page) {
    blockSave.blockedPages = blockSave.blockedPages.filter(p => p !== page);
    if (blockSave.blockedPages.length === 0) {
        blockSave.reason = "";
    }
}

export {
    getSettingsData,
    updateSettingsData,
    getStylesData,
    updateStylesData,
    getIBCSSettingsData,
    updateIBCSSettingsData,
    getIBCSStylesData,
    updateIBCSStylesData,
    getFontFaceDefinitions,
    addFontFaceDefinition,
    removeFontFaceDefinition,
    getTranslationsData,
    updateTranslationsData,
    refreshTranslationsData,
    hasUnsavedChanges,
    setUnsavedChanges,
    getBlockedPages,
    addBlockedPage,
    removeBlockedPage
};
