<%@ include file="auth-check.jspf" %>

<% if (request.getAttribute("isMstrSessionAlive") != null) { %>
<html lang="en" class="vitara-checkHealth-root">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Microstrategy Health Status</title>
    <link rel="stylesheet" href="./CheckHealth/styles.css">
</head>
<body>
    <div class="vitara-checkHealth">
        <h1 class="page-title">Welcome to Vitara Charts!</h1>
        <div class="card">
            <div class="card_item">
                <span class="card_item-title">Platform Name: </span>
                <span class="platform_name"></span>
            </div>
            <div class="card_item">
                <span class="card_item-title">Plugin Name: </span>
                <span class="plugin_name"></span>
            </div>
            <div class="card_item">
                <span class="card_item-title">Plugin version: </span>
                <span class="plugin_version"></span>
            </div>
        </div>
        <section>
            <ul class="status-table"></ul>
            <div class="error-log">
                <button onclick="copyErrorsToClipboard()">Copy Errors to Clipboard</button>
                <div id="copyStatus" style="margin-top: 10px; color: green;"></div>
            </div>
            <div class="error-display-section"></div>
        </section>
    </div>

    <script src="./CheckHealth/script.js" nonce="<%= request.getAttribute("com.microstrategy.csp_nonce") %>"></script>
</body>
</html>
<% } else if (request.getAttribute("isMstrNotAuthenticated") != null) { %>
<style>
    body {
        font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol";
        background-color: #f0f2f5;
        display: flex;
        justify-content: center;
        align-items: center;
        height: 100vh;
        margin: 0;
    }
    .auth-message-container {
        background-color: #fff;
        padding: 40px;
        border-radius: 8px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        text-align: center;
        max-width: 400px;
    }
    .auth-message-container h2 {
        color: #1c1e21;
        font-size: 24px;
        margin-bottom: 10px;
    }
    .auth-message-container p {
        color: #606770;
        font-size: 16px;
        margin-bottom: 25px;
    }
    .auth-message-container .redirect-button {
        background-color: #1877f2;
        color: #fff;
        border: none;
        border-radius: 6px;
        font-size: 17px;
        font-weight: bold;
        padding: 12px 20px;
        text-decoration: none;
        cursor: pointer;
        transition: background-color 0.3s;
    }
    .auth-message-container .redirect-button:hover {
        background-color: #166fe5;
    }
</style>
<div class="auth-message-container">
    <h2>Access Denied</h2>
    <p>You must be logged in to MicroStrategy to use this tool.</p>
    <a href="../../../" class="redirect-button">Go to Home Page</a>
</div>
<% } %>
