const chartClassMapping = {
    "VitaraHCBarChart": "Bar",
    "VitaraHCStackedBarChart": "Stacked Bar",
    "VitaraHCColumnChart": "Column",
    "VitaraHCStackedColumnChart": "Stacked Column",
    "VitaraHCLineChart": "Line",
    "VitaraHCAreaChart": "Area",
    "VitaraHCBubbleChart": "Bubble",
    "VitaraHCBulletChart": "Bullet",
    "VitaraHCPieChart": "Pie",
    "VitaraHCFunnelChart": "Funnel",
    "VitaraHCTornadoChart": "Tornado",
    "VitaraHCSparklineChart": "Sparkline",
    "VitaraHCHeatmapChart": "Heatmap",
    "VitaraHCColumnRangeChart": "Column Range",
    "VitaraHCWaterfallChart": "Waterfall",
    "VitaraSimpleKPIChart": "Simple KPI",
    "VitaraHCKPIRingChart": "KPI Ring",
    "VitaraD3KPIAnimationChart": "KPI Animation",
    "VitaraD3CalHeatMapChart": "Calendar Heatmap",
    "VitaraHCMekkoChart": "Mekko",
    "VitaraHCWordCloud": "Word Cloud",
    "VitaraD3WaffleChart": "Waffle",
    "VitaraHCHistogramChart": "Histogram",
    "VitaraHCDumbbellChart": "Dumbbell",
    "VitaraHCSlopeChart": "Slope",
    "VitaraD3CirclePackingChart": "Packed Bubble",
    "VitaraHCAngularGaugeChart": "Angular Gauge",
    "VitaraHCSankeyChart": "Sankey",
    "VitaraGridChart": "Grid/Micro"
};

const ibcsChartMapping = {
    "IBCSStandard": "IBCS Standard View",
    "IBCSWaterfall": "IBCS Waterfall"
};

const stylePropertyMapping = {
    "chart-background": {
        name: "Chart Background",
        classList: [".vitara-chart-background"],
        supportedFields: ["background-color-styling"],
        stylingTarget: "highcharts-d3-styling"
    },
    "plot-background": {
        name: "Plot Background",
        classList: [".vitara-plot-background"],
        supportedFields: ["background-color-styling"],
        stylingTarget: "highcharts-d3-styling"
    },
    "category-axis": {
        name: "Category Axis",
        classList: [".vitara-category-axis"],
        supportedFields: ["text-color-styling", "font-size-styling", "font-family-styling", "text-transform-styling", "letter-spacing-styling", "bold-styling", "italic-styling", "underline-styling"],
        stylingTarget: "highcharts-d3-styling"
    },
    "value-axis": {
        name: "Value Axis",
        classList: [".vitara-value-axis"],
        supportedFields: ["text-color-styling", "font-size-styling", "font-family-styling", "text-transform-styling", "letter-spacing-styling", "bold-styling", "italic-styling", "underline-styling"],
        stylingTarget: "highcharts-d3-styling"
    },
    "axis-title": {
        name: "Axis Title",
        classList: [".vitara-axis-title"],
        supportedFields: ["text-color-styling", "font-size-styling", "font-family-styling", "text-transform-styling", "letter-spacing-styling", "bold-styling", "italic-styling", "underline-styling"],
        stylingTarget: "highcharts-d3-styling"
    },
    "axis-line": {
        name: "Axis Line",
        classList: [".vitara-axis-line"],
        supportedFields: ["line-color-styling", "line-width-styling"],
        stylingTarget: "highcharts-d3-styling"
    },
    "line-display": {
        name: "Line Display",
        classList: [".vitara-line-display"],
        supportedFields: ["line-color-styling", "line-width-styling", "line-dash-pattern-styling"],
        stylingTarget: "highcharts-d3-styling"
    },
    "grid-line": {
        name: "Grid Line",
        classList: [".vitara-grid-line"],
        supportedFields: ["line-color-styling", "line-width-styling", "line-dash-pattern-styling"],
        stylingTarget: "highcharts-d3-styling"
    },
    "legend-text": {
        name: "Legend Text",
        classList: [".vitara-legend-text"],
        supportedFields: ["text-color-styling", "font-size-styling", "font-family-styling", "text-transform-styling", "letter-spacing-styling", "bold-styling", "italic-styling", "underline-styling"],
        stylingTarget: "highcharts-d3-styling"
    },
    "datalabel": {
        name: "Data Label",
        classList: [".vitara-datalabel"],
        supportedFields: ["text-color-styling", "font-size-styling", "font-family-styling", "text-transform-styling", "letter-spacing-styling", "bold-styling", "italic-styling", "underline-styling"],
        stylingTarget: "highcharts-d3-styling"
    },
    "data-point": {
        name: "Point/Bar/Bubble/Marker",
        classList: [".vitara-point"],
        supportedFields: ["background-color-styling", "line-color-styling", "line-width-styling", "line-dash-pattern-styling"],
        stylingTarget: "highcharts-d3-styling"
    },
    "all-rows": {
        name: "All Rows",
        classList: [".vitara-row"],
        supportedFields: ["background-color-styling", "text-color-styling", "font-size-styling", "font-family-styling", "text-transform-styling", "letter-spacing-styling", "bold-styling", "italic-styling", "underline-styling"],
        stylingTarget: "grid-styling"
    },
    "even-rows": {
        name: "Even Rows",
        classList: [".vitara-row.vitara-grid-row-even"],
        supportedFields: ["background-color-styling", "text-color-styling", "font-size-styling", "font-family-styling", "text-transform-styling", "letter-spacing-styling", "bold-styling", "italic-styling", "underline-styling"],
        stylingTarget: "grid-styling"
    },
    "odd-rows": {
        name: "Odd Rows",
        classList: [".vitara-row.vitara-grid-row-odd"],
        supportedFields: ["background-color-styling", "text-color-styling", "font-size-styling", "font-family-styling", "text-transform-styling", "letter-spacing-styling", "bold-styling", "italic-styling", "underline-styling"],
        stylingTarget: "grid-styling"
    },
    "grouped-rows": {
        name: "Grouped Rows",
        classList: [".vitara-row.vitara-grid-row-group"],
        supportedFields: ["background-color-styling", "text-color-styling", "font-size-styling", "font-family-styling", "text-transform-styling", "letter-spacing-styling", "bold-styling", "italic-styling", "underline-styling"],
        stylingTarget: "grid-styling"
    },
    "even-grouped-rows": {
        name: "Even Grouped Rows",
        classList: [".vitara-row.vitara-grid-row-even.vitara-grid-row-group"],
        supportedFields: ["background-color-styling", "text-color-styling", "font-size-styling", "font-family-styling", "text-transform-styling", "letter-spacing-styling", "bold-styling", "italic-styling", "underline-styling"],
        stylingTarget: "grid-styling"
    },
    "odd-grouped-rows": {
        name: "Odd Grouped Rows",
        classList: [".vitara-row.vitara-grid-row-odd.vitara-grid-row-group"],
        supportedFields: ["background-color-styling", "text-color-styling", "font-size-styling", "font-family-styling", "text-transform-styling", "letter-spacing-styling", "bold-styling", "italic-styling", "underline-styling"],
        stylingTarget: "grid-styling"
    },
    "normal-header": {
        name: "Normal Header",
        classList: [".vitara-header.vitara-grid-header-cell"],
        supportedFields: ["background-color-styling", "text-color-styling", "font-size-styling", "font-family-styling", "text-transform-styling", "letter-spacing-styling", "bold-styling", "italic-styling", "underline-styling"],
        stylingTarget: "grid-styling"
    },
    "grouped-header": {
        name: "Grouped Header",
        classList: [".vitara-header.vitara-grid-grouped-header-cell"],
        supportedFields: ["background-color-styling", "text-color-styling", "font-size-styling", "font-family-styling", "text-transform-styling", "letter-spacing-styling", "bold-styling", "italic-styling", "underline-styling"],
        stylingTarget: "grid-styling"
    },
    "subtotal-header": {
        name: "Subtotal Header",
        classList: [".vitara-grid-subtotals-header.vitara-grid-subtotals-cell"],
        supportedFields: ["background-color-styling", "text-color-styling", "font-size-styling", "font-family-styling", "text-transform-styling", "letter-spacing-styling", "bold-styling", "italic-styling", "underline-styling"],
        stylingTarget: "grid-styling"
    },
    "subtotal-value": {
        name: "Subtotal Value",
        classList: [".vitara-grid-subtotals-value.vitara-grid-subtotals-cell"],
        supportedFields: ["background-color-styling", "text-color-styling", "font-size-styling", "font-family-styling", "text-transform-styling", "letter-spacing-styling", "bold-styling", "italic-styling", "underline-styling"],
        stylingTarget: "grid-styling"
    },
    "even-columns": {
        name: "Even Columns",
        classList: [".vitara-grid-column:nth-child(2n)"],
        supportedFields: ["background-color-styling", "text-color-styling", "font-size-styling", "font-family-styling", "text-transform-styling", "letter-spacing-styling", "bold-styling", "italic-styling", "underline-styling"],
        stylingTarget: "grid-styling"
    },
    "odd-columns": {
        name: "Odd Columns",
        classList: [".vitara-grid-column:nth-child(2n+1)"],
        supportedFields: ["background-color-styling", "text-color-styling", "font-size-styling", "font-family-styling", "text-transform-styling", "letter-spacing-styling", "bold-styling", "italic-styling", "underline-styling"],
        stylingTarget: "grid-styling"
    },
    "grand-total-column-header": {
        name: "Grand Total Column Header",
        classList: [".vitara-grand-totals-header.vitara-grand-totals-cell"],
        supportedFields: ["background-color-styling", "text-color-styling", "font-size-styling", "font-family-styling", "text-transform-styling", "letter-spacing-styling", "bold-styling", "italic-styling", "underline-styling"],
        stylingTarget: "grid-styling"
    },
    "grand-total-column-value": {
        name: "Grand Total Column Value",
        classList: [".vitara-grand-totals-value.vitara-grand-totals-cell"],
        supportedFields: ["background-color-styling", "text-color-styling", "font-size-styling", "font-family-styling", "text-transform-styling", "letter-spacing-styling", "bold-styling", "italic-styling", "underline-styling"],
        stylingTarget: "grid-styling"
    },
    "grand-total-row": {
        name: "Grand Total Row",
        classList: [".vitara-grand-totals.vitara-grand-totals"],
        supportedFields: ["background-color-styling", "text-color-styling", "font-size-styling", "font-family-styling", "text-transform-styling", "letter-spacing-styling", "bold-styling", "italic-styling", "underline-styling"],
        stylingTarget: "grid-styling"
    },
    "grand-total-header": {
        name: "Grand Total Header",
        classList: [".vitara-grand-totals-header.vitara-grand-totals-cell"],
        supportedFields: ["background-color-styling", "text-color-styling", "font-size-styling", "font-family-styling", "text-transform-styling", "letter-spacing-styling", "bold-styling", "italic-styling", "underline-styling"],
        stylingTarget: "grid-styling"
    },
    "grand-total-value": {
        name: "Grand Total Value",
        classList: [".vitara-grand-totals-value.vitara-grand-totals-cell"],
        supportedFields: ["background-color-styling", "text-color-styling", "font-size-styling", "font-family-styling", "text-transform-styling", "letter-spacing-styling", "bold-styling", "italic-styling", "underline-styling"],
        stylingTarget: "grid-styling"
    },
    "ibcs-standard-actual": {
        name: "Actual Data",
        classList: [".ibcs-data .vitara-point"],
        supportedFields: ["background-color-styling", "line-color-styling"],
        stylingTarget: "ibcs-standard-styling"
    },
    "ibcs-standard-planned": {
        name: "Planned Data",
        classList: [".ibcs-data.planned-data .vitara-point"],
        supportedFields: ["line-color-styling"],
        stylingTarget: "ibcs-standard-styling"
    },
    "ibcs-standard-previous": {
        name: "Previous Data",
        classList: [".ibcs-data.previous-data .vitara-point"],
        supportedFields: ["background-color-styling", "line-color-styling"],
        stylingTarget: "ibcs-standard-styling"
    },
    "ibcs-standard-forecast": {
        name: "Forecast Data",
        classList: [".ibcs-data.forecast-data .vitara-point"],
        supportedFields: ["line-color-styling"],
        stylingTarget: "ibcs-standard-styling"
    },
    "ibcs-delta-view-positive": {
        name: "Delta View (Positive)",
        classList: [".vitara-point.ibcs-data.data-positive", ".vitara-point.ibcs-data.data-positive .vitara-marker", ".vitara_stripes_positive path"],
        supportedFields: ["background-color-styling", "line-color-styling"],
        stylingTarget: "ibcs-standard-styling"
    },
    "ibcs-delta-view-negative": {
        name: "Delta View (Negative)",
        classList: [".vitara-point.ibcs-data.data-negative", ".vitara-point.ibcs-data.data-negative .vitara-marker", ".vitara_stripes_negative path"],
        supportedFields: ["background-color-styling", "line-color-styling"],
        stylingTarget: "ibcs-standard-styling"
    },
    "ibcs-waterfall-actual-positive": {
        name: "Actual Data (Positive)",
        classList: [".actual-data .vitara-point.ibcs-data.data-positive"],
        supportedFields: ["background-color-styling", "line-color-styling"],
        stylingTarget: "ibcs-waterfall-styling"
    },
    "ibcs-waterfall-actual-negative": {
        name: "Actual Data (Negative)",
        classList: [".actual-data .vitara-point.ibcs-data.data-negative"],
        supportedFields: ["background-color-styling", "line-color-styling"],
        stylingTarget: "ibcs-waterfall-styling"
    },
    "ibcs-waterfall-planned-positive": {
        name: "Planned Data (Positive)",
        classList: [".planned-data .vitara-point.ibcs-data.data-positive"],
        supportedFields: ["line-color-styling"],
        stylingTarget: "ibcs-waterfall-styling"
    },
    "ibcs-waterfall-planned-negative": {
        name: "Planned Data (Negative)",
        classList: [".planned-data .vitara-point.ibcs-data.data-negative"],
        supportedFields: ["line-color-styling"],
        stylingTarget: "ibcs-waterfall-styling"
    },
    "ibcs-waterfall-previous-positive": {
        name: "Previous Data (Positive)",
        classList: [".previous-data .vitara-point.ibcs-data.data-positive"],
        supportedFields: ["background-color-styling", "line-color-styling"],
        stylingTarget: "ibcs-waterfall-styling"
    },
    "ibcs-waterfall-previous-negative": {
        name: "Previous Data (Negative)",
        classList: [".previous-data .vitara-point.ibcs-data.data-negative"],
        supportedFields: ["background-color-styling", "line-color-styling"],
        stylingTarget: "ibcs-waterfall-styling"
    }
};

export {
    chartClassMapping,
    ibcsChartMapping,
    stylePropertyMapping
};
