<%@ include file="auth-check.jspf" %>

<% if (request.getAttribute("isMstrSessionAlive") != null) { %>
<%
    // CSRF token is now generated here, only for authenticated sessions
    String csrfToken = (String) session.getAttribute("csrfToken");
    if (csrfToken == null) {
        csrfToken = java.util.UUID.randomUUID().toString();
        session.setAttribute("csrfToken", csrfToken);
    }
%>
<html lang="en" class="vitara-customization-ui-root">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Customize VitaraCharts</title>
    <link rel="stylesheet" href="./CustomEditor/styles.css">
</head>
<body class="vitara-customization-ui-body">
    <div id="vitara-customization-editor">
        <div class="tab-container">
            <ul class="tab-header">
                <li class="tab-navigation active" data-tab-key="settings">Settings</li>
                <li class="tab-navigation" data-tab-key="styles">Styles</li>
                <li class="tab-navigation" data-tab-key="translations">Translations</li>
            </ul>

            <div class="tab settings visible">
                <form enctype="multipart/form-data">
                    <input type="hidden" name="csrfToken" value="<%= csrfToken %>">
                    <div class="form-header">
                        <h1>Chart Settings</h1>
                        <button type="submit" class="save-changes" data-form-type="settings">Save Changes</button>
                    </div>
                    <div class="chart-settings">
                        <section class="create-palette-section">
                            <div class="section-title">
                                <h2>Create New Palette</h2>
                            </div>
                            <div class="table-field">
                                <label>Palette Name</label>
                                <input type="text" class="palette-name">
                            </div>
                            <div class="table-field color-picker-field">
                                <label>Palette Colors</label>
                                <div class="color-pickers-container">
                                    <button class="add-color">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="#249b43"><path d="M0 0h24v24H0z" fill="none"/><path d="M19 13h-6v6h-2v-6H5v-2h6V5h2v6h6v2z"/></svg>
                                    </button>
                                </div>
                            </div>
                            <div class="table-field">
                                <div class="hidden-block"></div>
                                <button class="clear-palette">Clear</button>
                                <button class="save-palette">Save Palette</button>
                            </div>
                        </section>

                        <section class="saved-palettes-section">
                            <div class="section-title section-header">
                                <h2>Saved Palettes</h2>
                                <ul class="action-labels">
                                    <li>Active</li>
                                    <li>Default</li>
                                </ul>
                            </div>
                            <div class="table-field">
                                <ul class="palette-list"></ul>
                            </div>
                        </section>

                        <section class="upload-font-section">
                            <div class="section-title">
                                <h2>Add New Font</h2>
                            </div>
                            <div class="table-field">
                                <label>
                                    <span class="info-tooltip" title="Font family label to be used for @font-face definition">Font Label</span>
                                </label>
                                <input type="text" class="font-name">
                            </div>
                            <div class="table-field">
                                <label>
                                    <span class="info-tooltip" title="Name of the source font file expected under 'custom/fonts' folder">Source File</span>
                                </label>
                                <input type="text" class="font-file-name" placeholder="e.g. Roboto.ttf or Lato/Lato.ttf">
                            </div>
                            <div class="table-field">
                                <div class="hidden-block"></div>
                                <button class="clear-font">Clear</button>
                                <button class="save-font">Add Font</button>
                            </div>
                        </section>

                        <section class="saved-fonts-section">
                            <div class="section-title section-header">
                                <h2>Saved Fonts</h2>
                                <ul class="action-labels">
                                    <li>Default</li>
                                </ul>
                            </div>
                            <div class="table-field">
                                <ul class="font-list"></ul>
                            </div>
                        </section>

                        <section class="grid-themes-section">
                            <div class="section-title">
                                <h2>Create Grid Theme</h2>
                            </div>
                            <div class="table-field">
                                <label>Theme Name</label>
                                <input type="text" class="grid-theme-name">
                            </div>

                            <div class="table-field">
                                <div class="hidden-block"></div>
                                <button class="clear-grid-theme">Clear</button>
                                <button class="save-grid-theme">Create Theme</button>
                            </div>
                        </section>

                        <section class="saved-grid-themes-section">
                            <div class="section-title section-header">
                                <h2>Saved Grid Themes</h2>
                                <ul class="action-labels">
                                    <li>Default</li>
                                </ul>
                            </div>
                            <div class="table-field">
                                <ul class="grid-theme-list"></ul>
                            </div>
                        </section>

                        <section class="general-settings">
                            <div class="section-title">
                                <h2>General Settings</h2>
                            </div>
                            <div class="table-field">
                                <label for="enable-privilege" class="custom-check">
                                    <span class="custom-check-label info-tooltip" title="User privilege for enabling Vitara Property Editor in MSTR documents">Enable Privilege for Editor</span>
                                    <input type="checkbox" id="enable-privilege">
                                    <span class="custom-check-icon"></span>
                                </label>
                            </div>
                            <div class="table-field">
                                <label>
                                    <span class="info-tooltip" title="Default (125) or other valid DSSXML Permission values">Permission Value:</span>
                                </label>

                                <label for="default-privilege" class="custom-radio">
                                    <span class="custom-radio-label">Default</span>
                                    <input type="radio" name="editor-privilege" id="default-privilege">
                                    <span class="custom-radio-icon"></span>
                                </label>

                                <label for="custom-privilege" class="custom-radio">
                                    <span class="custom-radio-label">Custom</span>
                                    <input type="radio" name="editor-privilege" id="custom-privilege">
                                    <span class="custom-radio-icon"></span>
                                </label>

                                <input type="number" class="custom-privilege-value">

                                <span class="info-text">
                                    (Refer DSSXML Permission Values
                                    <a href="https://www2.microstrategy.com/producthelp/Current/WebAPIReference/com/microstrategy/webapi/EnumDSSXMLPrivilegeTypes.html" target="_blank" rel="noreferrer noopener">here</a>)
                                </span>
                            </div>
                            <div class="table-field">
                                <label for="chart-animation-check" class="custom-check">
                                    <span class="custom-check-label">Enable Chart Animations</span>
                                    <input type="checkbox" id="chart-animation-check" class="chart-animations">
                                    <span class="custom-check-icon"></span>
                                </label>
                            </div>
                            <div class="table-field">
                                <label>Base Theme For Custom Grid Themes:</label>
                                <select class="base-grid-theme">
                                    <option value="Fresh">Fresh</option>
                                    <option value="Dark">Dark</option>
                                    <option value="Blue">Blue</option>
                                    <option value="White">White</option>
                                </select>
                            </div>
                            <div class="table-field">
                                <label for="links-access-check" class="custom-check">
                                    <span class="custom-check-label">Enable URL Links</span>
                                    <input type="checkbox" id="links-access-check" class="links-access">
                                    <span class="custom-check-icon"></span>
                                </label>
                            </div>
                            <div class="table-field">
                                <label for="context-menu-check" class="custom-check">
                                    <span class="custom-check-label">Enable Context Menu in Presentation Mode</span>
                                    <input type="checkbox" id="context-menu-check" class="context-menu-access">
                                    <span class="custom-check-icon"></span>
                                </label>
                            </div>
                            <div class="table-field">
                                <label for="rtl-support-check" class="custom-check">
                                    <span class="custom-check-label">Enable Right-To-Left Support</span>
                                    <input type="checkbox" id="rtl-support-check" class="rtl-support">
                                    <span class="custom-check-icon"></span>
                                </label>
                            </div>
                            <div class="table-field">
                                <label>Metric Negative Value Formatting:</label>
                                <select class="negative-value-format">
                                    <option value="-1">Microstrategy Format</option>
                                    <option value="0">- Minus sign</option>
                                    <option value="1">() Parenthesis</option>
                                </select>
                            </div>
                            <div class="table-field">
                                <label>Series Limit:</label>
                                <input type="number" min="1" class="series-colors-limit">
                            </div>
                            <div class="table-field">
                                <label>Metric Short Format Symbols:</label>
                                <input type="text" class="metric-suffix" value="k">
                                <input type="text" class="metric-suffix" value="M">
                                <input type="text" class="metric-suffix" value="B">
                                <input type="text" class="metric-suffix" value="T">
                                <input type="text" class="metric-suffix" value="P">
                                <input type="text" class="metric-suffix" value="E">
                                <span class="info-text">(e.g. 200k, 3M, 1B)</span>
                            </div>
                            <div class="table-field">
                                <label>
                                    <span class="info-tooltip" title="User access control levels for enabling Vitara Property Editor in MSTR documents">Access Control Levels:</span>
                                </label>
                                <label class="custom-check">
                                    <span class="custom-check-label">Read</span>
                                    <input type="checkbox" class="access-control-level" data-access-level="read">
                                    <span class="custom-check-icon"></span>
                                </label>
                                <label class="custom-check">
                                    <span class="custom-check-label">Write</span>
                                    <input type="checkbox" class="access-control-level" data-access-level="write">
                                    <span class="custom-check-icon"></span>
                                </label>
                                <label class="custom-check">
                                    <span class="custom-check-label">Delete</span>
                                    <input type="checkbox" class="access-control-level" data-access-level="delete">
                                    <span class="custom-check-icon"></span>
                                </label>
                                <label class="custom-check">
                                    <span class="custom-check-label">Use</span>
                                    <input type="checkbox" class="access-control-level" data-access-level="use">
                                    <span class="custom-check-icon"></span>
                                </label>
                                <label class="custom-check">
                                    <span class="custom-check-label">Execute</span>
                                    <input type="checkbox" class="access-control-level" data-access-level="execute">
                                    <span class="custom-check-icon"></span>
                                </label>
                                <label class="custom-check">
                                    <span class="custom-check-label">Full Control</span>
                                    <input type="checkbox" class="access-control-level" data-access-level="fullcontrol">
                                    <span class="custom-check-icon"></span>
                                </label>
                            </div>
                        </section>
                        <section class="ibcs-settings">
                            <div class="section-title">
                                <h2>IBCS Settings</h2>
                            </div>
                            <div class="table-field">
                                <label for="ibcs-default-check" class="custom-check">
                                    <span class="custom-check-label">Enable IBCS by Default</span>
                                    <input type="checkbox" id="ibcs-default-check" class="ibcs-default">
                                    <span class="custom-check-icon"></span>
                                </label>
                            </div>
                            <div class="table-field">
                                <label>AC (Actual):</label>
                                <input type="text" class="actual-data-type">
                            </div>
                            <div class="table-field">
                                <label>FC (Forecast):</label>
                                <input type="text" class="forecast-data-type">
                            </div>
                            <div class="table-field">
                                <label>PL (Planned):</label>
                                <input type="text" class="planned-data-type">
                            </div>
                            <div class="table-field">
                                <label>PY (Previous Year):</label>
                                <input type="text" class="previous-data-type">
                            </div>
                            <div class="table-field">
                                <label>Negative Metrics:</label>
                                <input type="text" class="negative-metrics">
                            </div>
                        </section>
                    </div>
                </form>
            </div>
            <div class="tab styles">
                <form action="">
                    <input type="hidden" name="csrfToken" value="<%= csrfToken %>">
                    <div class="form-header">
                        <h1>Chart Styles (Beta)</h1>
                        <button type="submit" class="save-changes" data-form-type="styles">Save Changes</button>
                    </div>
                    <div class="chart-styles">
                        <section>
                            <div>
                                <h2>Select Scope And Chart Component</h2>
                            </div>
                            <div class="table-field">
                                <label>Change Customization:</label>
                                <select class="stylesheet-dropdown">
                                    <option value="normal-stylesheet">Custom Styles</option>
                                    <option value="ibcs-stylesheet">IBCS Custom Styles</option>
                                </select>
                            </div>
                        </section>
                        <section class="style-scope-section">
                            <div class="table-field">
                                <label>Scope:</label>
                                <select class="styling-scope">
                                    <option value="global">Global (All Charts)</option>
                                </select>
                            </div>
                            <div class="table-field hidden">
                                <label>Grid Theme:</label>
                                <select class="grid-theme-scope">
                                    <option value="global">None (Global Styles)</option>
                                </select>
                            </div>
                            <div class="table-field">
                                <label>Chart Component:</label>
                                <select class="styling-component"></select>
                            </div>
                        </section>
                        <section class="style-editor-section">
                            <div class="table-field">
                                <label>Font Family:</label>
                                <select class="font-family-styling"></select>
                            </div>
                            <div class="table-field">
                                <label>Font Size:</label>
                                <input type="number" class="font-size-styling" min="0">
                            </div>
                            <div class="table-field">
                                <label>Text Color:</label>
                                <div class="color-picker-wrapper empty-color">
                                    <input type="color" class="color-picker text-color-styling">
                                </div>
                                <button class="remove-color">Remove Color</button>
                            </div>
                            <div class="table-field">
                                <label>Background Color (Fill):</label>
                                <div class="color-picker-wrapper empty-color">
                                    <input type="color" class="color-picker background-color-styling">
                                </div>
                                <button class="remove-color">Remove Color</button>
                            </div>
                            <div class="table-field">
                                <label>Line Width:</label>
                                <input type="number" class="line-width-styling" min="0">
                            </div>
                            <div class="table-field">
                                <label>Line Color (Stroke):</label>
                                <div class="color-picker-wrapper empty-color">
                                    <input type="color" class="color-picker line-color-styling">
                                </div>
                                <button class="remove-color">Remove Color</button>
                            </div>
                            <div class="table-field">
                                <label>Line Dash Pattern:</label>
                                <select class="line-dash-pattern-styling">
                                    <option value="none">Solid</option>
                                    <option value="3,1">ShortDash</option>
                                    <option value="1,1">ShortDot</option>
                                    <option value="3,1,1,1">ShortDashDot</option>
                                    <option value="3,1,1,1,1,1">ShortDashDotDot</option>
                                    <option value="1,3">Dot</option>
                                    <option value="4,3">Dash</option>
                                    <option value="8,3">LongDash</option>
                                    <option value="4,3,1,3">DashDot</option>
                                    <option value="8,3,1,3,1,3">LongDashDotDot</option>
                                </select>
                                <span class="info-text">
                                    (Note: Setting "Line Width" is recommended for better visibility of line patterns)
                                </span>
                            </div>
                            <div class="table-field">
                                <label>Text Transform:</label>
                                <select class="text-transform-styling">
                                    <option value="none">None</option>
                                    <option value="uppercase">Uppercase</option>
                                    <option value="lowercase">Lowercase</option>
                                    <option value="capitalize">Capitalize</option>
                                </select>
                            </div>
                            <div class="table-field">
                                <label>Letter Spacing:</label>
                                <input type="number" class="letter-spacing-styling" min="0">
                            </div>
                            <div class="table-field">
                                <label>Text Formatting:</label>
                                <label class="custom-check">
                                    <span class="custom-check-label">Bold</span>
                                    <input type="checkbox" class="bold-styling">
                                    <span class="custom-check-icon"></span>
                                </label>
                                <label class="custom-check">
                                    <span class="custom-check-label">Italic</span>
                                    <input type="checkbox" class="italic-styling">
                                    <span class="custom-check-icon"></span>
                                </label>
                                <label class="custom-check">
                                    <span class="custom-check-label">Underline</span>
                                    <input type="checkbox" class="underline-styling">
                                    <span class="custom-check-icon"></span>
                                </label>
                            </div>
                        </section>
                    </div>
                </form>
            </div>
            <div class="tab translations">
                <form action="">
                    <input type="hidden" name="csrfToken" value="<%= csrfToken %>">
                    <div class="form-header">
                        <h1>Chart Translations</h1>
                        <button type="submit" class="save-changes" data-form-type="translations">Save Changes</button>
                    </div>
                    <div class="chart-translations">
                        <section>
                            <b class="current-language">Language: <span class="translation-language">English</span></b>
                            <div class="table-field">
                                <label>Change Language:</label>
                                <select class="language-dropdown">
                                    <option value="English">English</option>
                                    <option value="English-US">English-US</option>
                                    <option value="French">French</option>
                                    <option value="German">German</option>
                                    <option value="Korean">Korean</option>
                                    <option value="Spanish">Spanish</option>
                                </select>
                            </div>
                        </section>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <script src="./CustomEditor/main.js" type="module" nonce="<%= request.getAttribute("com.microstrategy.csp_nonce") %>"></script>
</body>
</html>
<% } else if (request.getAttribute("isMstrNotAuthenticated") != null) { %>
<style>
    body {
        font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol";
        background-color: #f0f2f5;
        display: flex;
        justify-content: center;
        align-items: center;
        height: 100vh;
        margin: 0;
    }
    .auth-message-container {
        background-color: #fff;
        padding: 40px;
        border-radius: 8px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        text-align: center;
        max-width: 400px;
    }
    .auth-message-container h2 {
        color: #1c1e21;
        font-size: 24px;
        margin-bottom: 10px;
    }
    .auth-message-container p {
        color: #606770;
        font-size: 16px;
        margin-bottom: 25px;
    }
    .auth-message-container .redirect-button {
        background-color: #1877f2;
        color: #fff;
        border: none;
        border-radius: 6px;
        font-size: 17px;
        font-weight: bold;
        padding: 12px 20px;
        text-decoration: none;
        cursor: pointer;
        transition: background-color 0.3s;
    }
    .auth-message-container .redirect-button:hover {
        background-color: #166fe5;
    }
</style>
<div class="auth-message-container">
    <h2>Access Denied</h2>
    <p>You must be logged in to MicroStrategy to use this tool.</p>
    <a href="../../../" class="redirect-button">Go to Home Page</a>
</div>
<% } %>
