<%@ page import="java.io.*, java.util.*, java.nio.file.*, java.nio.charset.StandardCharsets" %>
<%@ page import="com.google.gson.Gson" %>
<%@ include file="utils.jspf" %>
<%!
public class CssValidationResult {
    public boolean isValid;
    public String content;
    public String errorMessage;

    public CssValidationResult(boolean isValid, String content, String errorMessage) {
        this.isValid = isValid;
        this.content = content;
        this.errorMessage = errorMessage;
    }
}

public CssValidationResult readCssFile(String cssFilePath) {
    if (cssFilePath == null || cssFilePath.trim().isEmpty()) {
        return new CssValidationResult(false, null, "CSS file path is not provided.");
    }

    File cssFile = new File(cssFilePath);
    if (!cssFile.exists()) {
        return new CssValidationResult(false, null, "CSS file does not exist.");
    }

    try {
        String content = new String(Files.readAllBytes(cssFile.toPath()), StandardCharsets.UTF_8); // ERROR HERE
        return new CssValidationResult(true, content, null);
    } catch (IOException e) {
        return new CssValidationResult(false, null, "Error reading CSS file: " + e.getMessage());
    }
}

public class GlobalTxtValidationResult {
    public boolean isValid;
    public Properties config;
    public String errorMessage;

    public GlobalTxtValidationResult(boolean isValid, Properties config, String errorMessage) {
        this.isValid = isValid;
        this.config = config;
        this.errorMessage = errorMessage;
    }
}

public GlobalTxtValidationResult readGlobalTxt(String filepath) {
    Properties config = new Properties();

    if (filepath == null || filepath.trim().isEmpty()) {
        return new GlobalTxtValidationResult(false, null, "Global config file path is not provided.");
    }

    File file = new File(filepath);
    if (!file.exists()) {
        return new GlobalTxtValidationResult(false, null, "Global config file does not exist.");
    }

    try (BufferedReader reader = new BufferedReader(new FileReader(file))) {
        String line;
        while ((line = reader.readLine()) != null) {
            line = line.trim();
            if (line.startsWith("#") || line.isEmpty()) continue;

            String[] parts = line.split("=", 2);
            if (parts.length == 2) {
                config.setProperty(parts[0].trim(), parts[1].trim());
            }
        }
        return new GlobalTxtValidationResult(true, config, null);
    } catch (IOException e) {
        return new GlobalTxtValidationResult(false, null, "Error reading global config file: " + e.getMessage());
    }
}

class customInfo {
    String status;
    Map<String, String> errors = new HashMap<>();
    Map<String, String> warnings = new HashMap<>();
    Map<String, Object> extraInfo = new HashMap<>();
    List<String> resolutions;

    customInfo(CssValidationResult cssContent, GlobalTxtValidationResult globalProp) {
        this.resolutions = new ArrayList<>();
        // Determine and collect errors
        if (!cssContent.isValid) {
            this.errors.put("customStyles.css", cssContent.errorMessage);
            this.resolutions.add(resolutionMessages.getOrDefault("E12", "custom css file missing. Redeploy plugin."));
        }

        if (!globalProp.isValid) {
            this.errors.put("global.txt", globalProp.errorMessage);
            this.resolutions.add(resolutionMessages.getOrDefault("E13", "global file missing. Redeploy plugin."));
        }

        // Final status
        this.status = errors.isEmpty() ? "pass" : "fail";

        // Fill in extra info
        this.extraInfo.put("cssContent", cssContent.content);
        this.extraInfo.put("globalConfig", globalProp.config);
    }
}
%>

<%
    Properties prop = readStateProperties(getRealPath(application, "VitaraCharts/utils/CheckHealth/state.properties"));    

    String globalFilePath = getRealPath(application, prop.getProperty("custom.global"));
    GlobalTxtValidationResult globalProp = readGlobalTxt(globalFilePath);
    String cssFilePath = getRealPath(application, prop.getProperty("custom.css"));
    CssValidationResult cssContent = readCssFile(cssFilePath);

    customInfo result = new customInfo(cssContent, globalProp);
    Gson gson = new Gson();
    String json = gson.toJson(result);
    response.setContentType("application/json");
    response.setCharacterEncoding("UTF-8");
    out.print(json);
    out.flush();
%>
